function GibbsGraphs(x,drop,nlag,labels)
%	GIBBSGRAPHS - GibbsGraphs(x,drop,nlag,labels)

[n,m]=size(x);
if drop>1
   ndrop = drop;
else
   ndrop = floor(drop*n);
end
nuse = n-ndrop;

if nuse<=200
   d=ndrop+1:n;
   DrawLabel='Draw';
elseif nuse<=1000
   d=ndrop+(1:5:min(nuse,1000));
   DrawLabel='Draw (Every Fifth)';
else
   d=ndrop+(1:10:min(nuse,2000));
   DrawLabel='Draw (Every Tenth)';
end

ac = autocorrelations(x(ndrop+1:n,:),nlag);
position = zeros(m,4);

for i=1:m
   
   subplot(m,3,3*(i-1)+1);
   plot(d,x(d,i),'.');
   xlabel(DrawLabel);
   %ylabel(labels(i),'Rotation',0);
   position(i,:) = get(gca,'Position');

   box off;
   
   subplot(m,3,3*(i-1)+2);
   [ra, ca] = size(ac);
   %bar(1:nlag,ac(2:end,i));
   plot(1:nlag,ac(2:end,i));
   line(1:nlag,0);
   set(gca,'YLim',[-1 1]);
   set(gca,'XLim',[1 ra-1]);
   xlabel('Lag');
   ylabel('Autocorrelation');
   box off;
   
   subplot(m,3,3*(i-1)+3);
   [nb,xout]=hist(x(ndrop+1:end,i),20);
   nb = nb/nuse;
	bar(xout,nb);
%   xlabel('Parameter Value');
%   xlabel(labels(i));
   ylabel('Relative Frequency');
   box off;
end

h = axes('Position',[0 0 1 1], 'Visible', 'off');
set(gcf,'currentaxes',h);
for i=1:m
   text(.01,position(i,2)+position(i,4),labels(i));
end;
